// Alumni Routes - Add these to routes/admin.js after the renderPending function

// Alumni students route
router.get('/students/alumni', async (req, res) => {
  const users = await userModel.getAll();
  const alumni = users.filter(u => u.role === 'student' && u.status === 'alumni');
  
  // Enhance alumni data with last course information
  const classes = await classModel.getAllClasses();
  const enhancedAlumni = alumni.map(student => {
    // Find most recent class they were enrolled in
    let lastCourse = null;
    let lastEndDate = null;
    
    classes.forEach(klass => {
      if ((klass.studentIds || []).includes(student.id)) {
        const endDate = klass.endDate ? new Date(klass.endDate) : null;
        if (endDate && (!lastEndDate || endDate > lastEndDate)) {
          lastEndDate = endDate;
          lastCourse = klass.title || klass.name;
        }
      }
    });
    
    return {
      ...student,
      lastCourseName: lastCourse,
      becameAlumniAt: student.becameAlumniAt || null
    };
  });
  
  res.render('admin_alumni', { alumni: enhancedAlumni, user: req.session.user });
});

// Reactivate alumni student
router.post('/students/:id/reactivate', async (req, res) => {
  try {
    const id = Number(req.params.id);
    const student = await userModel.findById(id);
    
    if (!student || student.role !== 'student') {
      return res.status(404).json({ error: 'Student not found' });
    }
    
    if (student.status !== 'alumni') {
      return res.status(400).json({ error: 'Student is not an alumni' });
    }
    
    // Reactivate to approved status
    await userModel.updateUser(id, { status: 'approved' });
    
    console.log(`Alumni student ${id} reactivated to approved status by admin ${req.session.user.id}`);
    res.json({ ok: true, message: 'Student reactivated successfully' });
    
  } catch (e) {
    console.error('Reactivate student error:', e);
    res.status(500).json({ error: 'Failed to reactivate student' });
  }
});
