# Attendance System Enhancement

## Overview
This update completely redesigns the attendance system for admins and teachers to provide a comprehensive Daily Attendance Log format similar to official school attendance records.

## Changes Made

### 1. Data Model Updates (`models/classModel.js`)

#### New Function: `recordDetailedAttendance(classId, attendanceData)`
Records enhanced attendance with:
- Date
- Scheduled hours (calculated from class schedule)
- Time in/out
- Per-student entries with:
  - Hours completed
  - Absent flag
  - Tardy flag
  - Reason (for absences/tardies)
- Instructor digital signature
- Signature timestamp

#### New Function: `getStudentAttendanceRecord(classId, studentId)`
Retrieves comprehensive attendance record for a student including:
- All attendance records with details
- Summary statistics:
  - Total scheduled hours
  - Total completed hours
  - Percentage completed
  - Compliance status (80% requirement)

### 2. Teacher View Updates (`views/teacher_view_class.ejs`)

#### Removed
- Contact button next to student names in attendance section

#### Added
- **Date field** - Auto-populated with current date, editable
- **Scheduled Hours** - Auto-calculated from class schedule, read-only
- **Time In/Time Out** - Auto-populated from schedule, editable
- **Recalculate Hours** button - Recalculates when times change

#### Per-Student Fields
- **Hours Completed** - Editable, auto-populated
- **Absent checkbox** - Zeros out hours when checked, disables tardy
- **Tardy checkbox** - Reduces hours to 75% by default
- **Reason field** - Optional explanation for absences/tardies
- **View Log button** - Links to comprehensive attendance record

#### Instructor Signature
- Digital signature canvas
- Captured and stored with attendance record
- Clear button to reset signature

#### Attendance History
- Improved display showing:
  - Date
  - Scheduled hours
  - Time range
  - Present count (with badge)
  - Signature status

### 3. Admin View Updates (`views/view_class.ejs`)

Same updates as teacher view with identical functionality for consistency.

### 4. New Student Attendance Record View (`views/student_attendance_record.ejs`)

Comprehensive "Official Attendance Record" page matching the provided design:

#### Student Information Section
- Name
- Student ID
- Program Title
- Program Number (Cohort)
- Start/End Dates

#### Attendance Policy
- 80% attendance requirement
- Absence/withdrawal rules
- Tardy conversion (3 tardies = 1 absence)

#### Attendance Summary
- Visual stat cards showing:
  - Total Scheduled Hours
  - Total Completed Hours
  - Percentage Completed (color-coded)
- Compliance status badge

#### Daily Attendance Log Table
- Date
- Scheduled Hours
- Time In/Out
- Hours Completed
- Status (Present/Absent/Tardy) with color-coded badges
- Reason
- Signature status
- Footer totals

#### Signatures Section
- Instructor signature line
- President signature line (for printed documents)

#### Print Support
- Print-optimized styles
- Letterhead included for printed documents
- Hide navigation elements when printing

### 5. New Routes

#### Teacher Routes (`routes/teacher.js`)
- `POST /teacher/classes/:id/attendance/detailed` - Save detailed attendance
- `GET /teacher/classes/:classId/students/:studentId/attendance-record` - View student attendance record

#### Admin Routes (`routes/admin.js`)
- `POST /admin/classes/:id/attendance/detailed` - Save detailed attendance
- `GET /admin/classes/:classId/students/:studentId/attendance-record` - View student attendance record

## Usage

### Taking Attendance
1. Navigate to class view (teacher or admin)
2. Date auto-populates to today
3. Time In/Out and Scheduled Hours auto-calculate from class schedule
4. For each student:
   - Leave unchecked for present (full hours)
   - Check "Absent" for absent students (zeros hours)
   - Check "Tardy" for late students (reduces hours to 75%)
   - Add optional reason for absences/tardies
5. Sign in the signature area
6. Click "Save Attendance"

### Viewing Student Attendance Record
1. Click "View Log" button next to any student
2. See comprehensive attendance history
3. Print for official records

## Backward Compatibility

The legacy `/attendance` POST route is preserved for backward compatibility. Existing attendance data will continue to work - it just won't have the enhanced fields (time in/out, entries, etc.) until new attendance is recorded.

## Theme Compliance

All new UI elements follow the existing MD Technical School theme:
- Primary color: Dodger Blue
- Secondary color: Orange
- Surface/card styling matches existing cards
- Bootstrap 5 components
- Bootstrap Icons
- Responsive design (mobile-friendly)
