# Quick Start Guide - Alumni & Grades Features

## 🚀 What's New

### 1. Alumni Students Management
**Where**: Admin Dashboard → Students → Alumni Students

**Features**:
- View all former students
- See last course taken
- Reactivate alumni to approved status
- Track when students became alumni

**Usage**:
```
1. Click "Alumni Students" tile on dashboard
2. View list of all alumni
3. Click "Reactivate" to restore student to active
4. Click "View" to see full profile
```

---

### 2. Move to Alumni (Manual)
**Where**: Student Profile (admin view, approved students only)

**Button Location**: Top right, next to "Home" button

**Usage**:
```
1. Open any approved student profile
2. Click "Move to Alumni" button (orange)
3. Confirm in dialog
4. Done! Student is now alumni
```

---

### 3. Auto-Transition to Alumni
**What**: Automatically moves students to alumni 1 week after last class ends

**Setup**:
```bash
# Test run
cd /path/to/app
node scripts/transitionToAlumni.js

# Add to crontab (daily at 2 AM)
crontab -e

# Add this line:
0 2 * * * cd /path/to/app && node scripts/transitionToAlumni.js >> logs/alumni.log 2>&1
```

---

### 4. Historical Gradebook
**What**: Record courses completed before LMS existed

**Routes** (Ready to use):
- `POST /admin/students/:id/historical-grades` - Add course
- `PUT /admin/students/:id/historical-grades/:courseId` - Edit course
- `DELETE /admin/students/:id/historical-grades/:courseId` - Delete course

**UI Code**: See `IMPLEMENTATION_SUMMARY.md` lines 273-450

**To Add UI**:
1. Open `views/student_profile.ejs`
2. Find certificates section
3. Add Historical Gradebook section after it
4. Copy code from IMPLEMENTATION_SUMMARY.md

---

### 5. Calendar Duplicate Fix
**What**: Prevents same event showing multiple times

**How It Works**: Now checks date + time + title (not just ID)

**Result**: No more duplicate interviews on calendar!

---

## 📝 Common Tasks

### Add a Past Course (Historical Grade)
```json
POST /admin/students/123/historical-grades
{
  "courseName": "Cybersecurity 101",
  "schoolYear": "2022-2023",
  "cohort": "Cohort 12",
  "startDate": "2022-09-01",
  "endDate": "2023-05-15",
  "clockHours": 600,
  "clockHoursCompleted": 600,
  "overallGrade": 92,
  "letterGrade": "A",
  "grades": [
    {"type": "test", "name": "Midterm", "score": 88},
    {"type": "test", "name": "Final", "score": 95}
  ],
  "notes": "Completed at previous location"
}
```

### Move Student to Alumni
```javascript
POST /admin/students/123/move-to-alumni
// No body needed
// Returns: {"ok": true}
```

### Reactivate Alumni
```javascript
POST /admin/students/123/reactivate
// No body needed
// Returns: {"ok": true}
```

---

## ✅ Testing Checklist

Quick tests to verify everything works:

1. [ ] Go to Admin Dashboard → see "Alumni Students" tile
2. [ ] Click tile → see alumni list page
3. [ ] Open approved student → see "Move to Alumni" button
4. [ ] Click button → student moves to alumni
5. [ ] Go to alumni list → see newly moved student
6. [ ] Click "Reactivate" → student back to approved
7. [ ] Run: `node scripts/transitionToAlumni.js` → no errors
8. [ ] Check calendar → no duplicate events

---

## 🔧 Configuration Needed

### 1. Set up cron job for auto-transition
```bash
# Edit crontab
crontab -e

# Add daily job at 2 AM
0 2 * * * cd /Users/backupadmin/Documents/GitHub/newLMS2/Untitled && node scripts/transitionToAlumni.js >> logs/alumni-transition.log 2>&1

# Create logs directory
mkdir -p logs
```

### 2. Add Historical Gradebook UI (Optional)
See `IMPLEMENTATION_SUMMARY.md` for complete UI code

---

## 📊 Status Flow

```
┌──────────────┐
│  Interested  │ (Pre-registrations)
└──────┬───────┘
       ↓
┌──────────────┐
│  Registered  │ (Pending approval)
└──────┬───────┘
       ↓
┌──────────────┐
│   Approved   │ (Active students) ←──────┐
└──────┬───────┘                          │
       ↓                                  │
┌──────────────┐                          │
│    Alumni    │ (Former students)        │
└──────┬───────┘                          │
       │                                  │
       └─────── Reactivate ───────────────┘
```

---

## 🎯 Quick Reference

### All New Routes
```
GET  /admin/students/alumni
POST /admin/students/:id/reactivate
POST /admin/students/:id/move-to-alumni
POST /admin/students/:id/historical-grades
PUT  /admin/students/:id/historical-grades/:courseId
DELETE /admin/students/:id/historical-grades/:courseId
```

### Files Modified
- `views/admin_dashboard.ejs` - Alumni tile + calendar fix
- `views/student_profile.ejs` - Move to Alumni button
- `routes/admin.js` - All alumni + grades routes

### Files Created
- `scripts/transitionToAlumni.js` - Auto-transition script
- `ALUMNI_AND_GRADES_IMPLEMENTATION.md` - Full docs

---

## 💡 Pro Tips

1. **Bulk Alumni**: If you have many historical students, add them as alumni directly instead of approved
2. **Grace Period**: The 7-day period can be changed in `transitionToAlumni.js` (line 27)
3. **Testing**: Run transition script manually first before setting up cron
4. **Historical Grades**: Add complete course history for better student records
5. **Calendar**: If you still see duplicates, clear browser cache

---

*Need more details? See ALUMNI_AND_GRADES_IMPLEMENTATION.md*  
*For historical gradebook UI: See IMPLEMENTATION_SUMMARY.md*
