# User Guide Updates - December 2024

## Summary
Updated comprehensive user guides for both Admin and Teacher roles covering all current system functionality.

## Files Updated

### 1. Admin User Guide
- **File:** `admin_user_guide.html`
- **Route:** `/admin/manual`
- **Old Version:** Backed up to `admin_user_guide_old.html`

### 2. Teacher User Guide
- **File:** `teacher_user_guide.html`
- **Route:** `/teacher/manual`
- **Old Version:** Backed up to `teacher_user_guide_old.html`

## Admin Guide Coverage

### Student Management
- Pending, Accepted, Alumni, Denied, Pre-Registered, Test Engine Access
- Profile management, enrollment, search & lookup
- Student merge tool
- To-do list management

### Documents & Signatures
- Student uploaded documents
- Required documents (admin upload)
- Digital signature workflow with field placement
- Signed documents management
- Certificates & awards
- Document templates

### Financial Management
- Automatic tuition calculation from enrolled courses
- Course matching (fuzzy matching algorithm)
- **Manual tuition entry** (for courses that don't auto-match)
- $75 fixed registration fee
- Financial dashboard & forecasting
- Payment tracking & bulk updates

### Grades & Transcripts
- Current grades from LMS classes
- Historical grades from other institutions
- Comprehensive transcript generation (PDF)
- Grade override & adjustments

### Teacher Management
- Create teachers with permissions
- Profile management
- Password resets
- Assistant teacher assignment

### Class Management
- Class creation & settings
- Student roster management
- Course content (lectures, PowerPoints, videos, links, syllabus)
- Assessments (tests, quizzes, CSV upload, test library, AI generation, external tests)
- Grading & attendance tracking
- Drip schedule
- Completion certificates

### Communications
- Direct messaging to students
- Announcements (Students/Teachers/Everyone)
- Email templates with variables
- Notifications configuration

### Marketing & Campaigns
- Marketing emails to segmented lists
- Drip campaigns for lead nurturing
- Lead tracking & interaction history
- Mentors & partners management

### Events & Calendar
- Event creation & management
- RSVP tracking & attendee lists
- Calendar integration with iCal export

### Reports & Analytics
- Student reports (pending, accepted, alumni, detailed individual)
- Class reports (summary, gradebook, attendance, roster)
- Financial reports (tuition summary, payment status, revenue forecast)
- Marketing reports (campaign performance, lead conversion)
- Custom report builder
- Charts & visualizations

### System Settings
- Branding (logo, director signature, color scheme)
- Dropdown options (courses, affiliates, document types)
- Email configuration (SMTP)
- User account settings

### Best Practices Section
- Daily, weekly, and monthly task checklists
- Data quality guidelines
- Communication best practices
- Security & privacy protocols
- Troubleshooting common issues

## Teacher Guide Coverage

### Dashboard
- My Classes overview
- Announcements
- Quick actions
- Recent activity
- Calendar view

### Profile Management
- Update bio, credentials, professional info
- Upload photo
- Add office hours and contact links
- Change password

### Class Management
- View all assigned classes
- Class settings (rename, description, discussion board)
- Student roster with export
- Class preview (student view)

### Course Content
- **Lectures:** PDFs, PowerPoints (auto-conversion), images, documents
- **Videos:** YouTube embeds, direct uploads, external links
- **Assignments:** Create with due dates, instructions, submission methods
- **Simulations:** Hands-on practice scenarios
- **External Resources:** Links with thumbnails and descriptions
- **Syllabus:** Upload and manage course syllabus PDF

### Tests & Assessments
- **Manual creation:** Multiple choice, true/false, short answer, essay
- **CSV bulk upload:** Import questions from spreadsheet
- **Test library:** Reuse questions from previous tests
- **AI-generated tests:** Create questions from topics
- **External tests:** Link to third-party platforms
- **Test settings:** Test vs. study mode, time limits, retakes, randomization
- **Question media:** Add images/diagrams to questions
- **Preview & edit:** Test functionality before students see it

### Grading
- Automatic grading (MC & T/F)
- Manual grading (essay & short answer)
- Gradebook view with sort/filter
- Export grades to CSV
- Print-friendly gradebook
- Grade override capability
- Individual student grade views
- Completion certificates (auto-generate & email)

### Student Management
- View student profiles
- Reset passwords
- Send emails to students
- View transcripts and historical grades
- Track progress and attendance
- Mark attendance for sessions
- Attendance reports and export

### Communication
- **Announcements:** Post to entire class
- **Discussion board:** Enable forum, moderate posts
- **Email:** Individual or class-wide emails
- **Mailbox:** View and reply to student messages

### Reports
- Class summary (enrollment, completion rates, average grades)
- Student progress tracking
- Grade distribution analysis
- Test performance analytics
- Individual student reports (PDF)
- Attendance reports
- Export capabilities (CSV)

### Teaching Tools
- **Content simplification tool:** AI-powered text simplification
- **AI teaching assistant:** Generate content, test questions, email templates
- **Drip schedule:** Release content on specific dates
- **Class checklist:** Course requirements tracker

### Best Practices Section
- Course organization strategies
- Engagement tactics
- Grading efficiency tips
- Student support guidelines
- Content quality standards
- Assessment best practices
- Time management advice
- Data privacy & security
- Troubleshooting guide

### Quick Reference Checklists
- Starting a new class checklist (8 steps)
- Weekly teaching tasks
- End of course tasks

## Key Features Highlighted

### New/Updated Features Documented
1. ✅ **Manual Tuition Entry** - Admin can add courses manually when auto-matching fails
2. ✅ **Fuzzy Course Matching** - Automatic matching of enrolled classes to program costs
3. ✅ **Digital Signature Workflow** - Interactive field placement and student signing
4. ✅ **Alumni Management** - Automatic and manual alumni transitions
5. ✅ **Historical Grades** - Add/edit/delete grades from other institutions
6. ✅ **Financial Forecasting** - Revenue projections with exclusion options
7. ✅ **AI Tools** - Test generation, content simplification, email assistance
8. ✅ **Drip Schedules** - Content release scheduling
9. ✅ **Student Merge Tool** - Consolidate duplicate records
10. ✅ **To-Do Templates** - Assignable checklists for students
11. ✅ **Career Advisor Integration** - Interview scheduling
12. ✅ **Test Engine Access** - Exam-only student accounts
13. ✅ **Certificate Management** - Upload, email, and auto-generate certificates
14. ✅ **Attendance Tracking** - Mark and report on student attendance
15. ✅ **Marketing Campaigns** - Drip campaigns and email marketing
16. ✅ **Custom Charts** - Dashboard visualizations

## Implementation Details

### Route Changes
- **Admin:** `/admin/manual` now serves `admin_user_guide.html` directly
- **Teacher:** `/teacher/manual` now serves `teacher_user_guide.html` directly
- Removed dependency on markdown files and marked library
- Simplified route handlers for faster loading

### Design Features
- Clean, modern HTML with embedded CSS
- Mobile-responsive layout
- Navigation menu with jump links
- Color-coded sections
- Tip boxes (blue) and warning boxes (yellow)
- Professional typography and spacing
- Print-friendly formatting

### Content Structure
Both guides follow a logical hierarchy:
1. Overview/Dashboard
2. Core functionality (users, classes, content)
3. Advanced features
4. Communication tools
5. Reports and analytics
6. System settings
7. Best practices and tips

## Access Instructions

### For Admins
1. Log in to admin account
2. Navigate to `/admin/manual` or look for "User Guide" link in navigation
3. Use table of contents to jump to specific sections

### For Teachers
1. Log in to teacher account
2. Navigate to `/teacher/manual` or look for "User Guide" link in navigation
3. Use table of contents for quick reference

## Maintenance Notes

- User guides are standalone HTML files in the project root
- Old versions backed up with `_old` suffix
- Update guides when new features are added
- Consider adding "Last Updated" version numbers when making changes
- Both guides include comprehensive feature coverage as of December 2024

## Future Enhancements Suggestions

1. Add PDF export button to guides
2. Create video tutorials linked from guide
3. Add search functionality within guides
4. Create quick-start one-page summaries
5. Translate guides to multiple languages
6. Add FAQ sections
7. Include system requirements and browser compatibility info

---

**Files Modified:**
- `/routes/admin.js` - Updated manual route
- `/routes/teacher.js` - Updated manual route
- `/admin_user_guide.html` - Complete rewrite (6.9KB → 29.7KB)
- `/teacher_user_guide.html` - Complete rewrite (2.9KB → 25KB)

**Files Backed Up:**
- `/admin_user_guide_old.html`
- `/teacher_user_guide_old.html`
