const fs = require('fs');
const path = require('path');

const simsDir = '/Users/backupadmin/Documents/GitHub/LMS/sims';

// Get all simulation directories
const simDirs = fs.readdirSync(simsDir).filter(item => {
  const fullPath = path.join(simsDir, item);
  return fs.statSync(fullPath).isDirectory();
});

console.log(`Found ${simDirs.length} simulation directories`);

let updatedCount = 0;
let errorCount = 0;

simDirs.forEach(simDir => {
  const indexPath = path.join(simsDir, simDir, 'index.html');
  
  if (!fs.existsSync(indexPath)) {
    console.log(`⚠️  No index.html in ${simDir}`);
    return;
  }
  
  try {
    let content = fs.readFileSync(indexPath, 'utf8');
    let modified = false;
    
    // Check if it already has the new structure
    if (content.includes('unity-progress-bar')) {
      console.log(`✓ ${simDir} already has new loading structure`);
      return;
    }
    
    // Replace the old loading overlay structure with the new one
    // Pattern: canvas-wrap div with loading overlay inside, followed by fullscreen button
    const oldPattern = /(<div class="canvas-wrap">[\s\S]*?<canvas[^>]*><\/canvas>)\s*<div id="unity-loading-overlay">\s*<div class="unity-spinner"><\/div>\s*<div class="unity-loading-text">Loading\.\.\.<\/div>\s*<\/div>\s*(<button class="btn btn-light btn-sm fullscreen-btn"[^>]*>.*?<\/button>\s*<\/div>)/;
    
    if (oldPattern.test(content)) {
      content = content.replace(
        oldPattern,
        `$1\n          $2\n        <div id="unity-loading-overlay">\n          <div class="unity-spinner"></div>\n          <div class="unity-loading-content">\n            <div class="unity-loading-text">Loading simulation...</div>\n            <div class="unity-progress-bar">\n              <div class="unity-progress-fill"></div>\n            </div>\n          </div>\n        </div>`
      );
      modified = true;
    }
    
    if (modified) {
      fs.writeFileSync(indexPath, content, 'utf8');
      console.log(`✓ Updated ${simDir}`);
      updatedCount++;
    } else {
      console.log(`⚠️  Could not update ${simDir} - pattern not found`);
    }
    
  } catch (error) {
    console.error(`✗ Error updating ${simDir}:`, error.message);
    errorCount++;
  }
});

console.log(`\n✓ Successfully updated ${updatedCount} files`);
if (errorCount > 0) {
  console.log(`✗ ${errorCount} files had errors`);
}
