# Course Completion Certificate Feature

## Overview
Added the ability for admins to send auto-generated course completion certificates to students directly from the grades section of their profile. This feature generates a professional PDF certificate and emails it to the student.

## Implementation Date
November 3, 2025

## Changes Made

### 1. Backend - Admin Routes (`routes/admin.js`)

#### Added PDFDocument Import
- **Line**: Added after line 76
- **Purpose**: Enable PDF generation for certificates
```javascript
const PDFDocument = require('pdfkit');
```

#### Added Helper Functions
- **Function**: `dataUrlToBuffer(url)`
  - Converts base64 data URLs to Buffer objects
  - Used for embedding signature images in PDFs
  
- **Function**: `buildCompletionPdf({ studentName, courseName, dateStr, instructorSig, directorSig })`
  - Generates a professional completion certificate PDF
  - Layout: Letter size, landscape orientation
  - Features:
    - Professional border design
    - School branding colors (#0d274d)
    - Student name on decorative line
    - Course name and completion date
    - Instructor and Director signatures at bottom
    - Signature fallback: uses director signature if teacher signature missing

#### New Route: Send Completion Certificate
- **Endpoint**: `POST /admin/classes/:classId/students/:studentId/send-completion-certificate`
- **Purpose**: Generate and email a completion certificate for a specific course
- **Process**:
  1. Validates student exists and has email address
  2. Retrieves class and teacher information
  3. Gets signatures (teacher signature with fallback to director signature)
  4. Generates PDF certificate using `buildCompletionPdf()`
  5. Emails certificate to student with admins CC'd
  6. Provides link to online certificate view
- **Response**: JSON with success/error status

### 2. Frontend - Student Profile View (`views/student_profile.ejs`)

#### Added Button in Grades Section
- **Location**: Next to "Set Final Grade" button
- **Button Features**:
  - Label: "Send Certificate"
  - Icon: Envelope with checkmark
  - Color: Primary blue (btn-primary)
  - Only visible to admins
  - Passes: classId, className, studentId, studentEmail

#### Added JavaScript Function
- **Function**: `sendCompletionCertificate(classId, className, studentId, studentEmail)`
- **Features**:
  - Validates student has email address
  - Shows confirmation dialog with course and email details
  - Displays loading spinner during generation/sending
  - Calls backend API endpoint
  - Shows success or error notification
  - Prevents accidental sends with confirmation dialog

## User Interface

### Button Location
The "Send Certificate" button appears in the grades section for each course, alongside:
- "View Detailed Report" (outline-primary)
- "Manage Grades" (warning)
- "Set Final Grade" (success/info)
- **"Send Certificate" (primary)** ← NEW

### User Flow
1. Admin navigates to student profile page
2. Scrolls to Grades section
3. Finds the course for which to send certificate
4. Clicks "Send Certificate" button next to "Set Final Grade"
5. Confirmation dialog appears with course name and student email
6. Admin confirms
7. System generates PDF and sends email
8. Success notification appears
9. Student receives email with certificate attachment

## Email Details

### Recipients
- **To**: Student's email address
- **CC**: All admin users
- **From**: noreply@mdts-apps.com

### Subject
"Certificate of Completion"

### Content
```
Congratulations [Student Name]! 
Your certificate of completion is attached or available [here].
```

### Attachments
- PDF file named "certificate.pdf"
- Contains completion certificate with signatures

## Certificate Design

### Layout
- **Size**: Letter (8.5" x 11")
- **Orientation**: Landscape
- **Margins**: 50pt all sides

### Content Elements
1. **Border**: 4pt decorative border in school blue (#0d274d)
2. **Header**: "CERTIFICATE OF COMPLETION" (32pt, blue)
3. **Student Name**: Prominently displayed on decorative line
4. **Course Name**: Course title in school blue
5. **Date**: Completion date
6. **Signatures**: 
   - Left: Instructor signature and title
   - Right: Director signature and title

### Signature Handling
- Uses teacher's signature from their profile
- Falls back to director signature from branding.json if teacher signature missing
- Both signatures displayed as images from base64 data

## Differences from Existing Certificate Features

### vs. Manual Certificate Upload/Email
- **Location**: Earned Certificates section
- **Purpose**: Email pre-uploaded certificate files
- **Use Case**: Sending external certificates, awards, etc.
- **Process**: No generation, just sends existing file

### vs. New Completion Certificate (This Feature)
- **Location**: Grades section
- **Purpose**: Generate and send course completion certificate
- **Use Case**: Certifying course completion based on grades
- **Process**: Generates PDF on-demand with current data

## Benefits

1. **Streamlined Workflow**: Send certificates directly from grade management area
2. **Context Awareness**: Button appears with grade context, making it clear when to use
3. **Automated Generation**: No need to manually create certificate PDFs
4. **Professional Design**: Consistent, branded certificate format
5. **Signature Integration**: Automatically includes appropriate signatures
6. **Audit Trail**: Admins CC'd on all certificate emails
7. **Online Access**: Students get both attachment and web link

## Security Considerations

- Admin-only access (role check)
- Student email validation
- Error handling for missing data
- Secure email transport (SMTP SSL)
- No direct file system access from client

## Future Enhancements

Potential improvements for future development:
- Add certificate to student's earned certificates automatically
- Customize certificate design per course/program
- Add certificate templates
- Track certificate send history
- Batch certificate sending for entire class
- Include course grades on certificate
- Add QR code for certificate verification
- Custom certificate text per course

## Testing Recommendations

1. **Basic Flow**:
   - Create a student with email
   - Enroll in course
   - Set final grade
   - Click "Send Certificate"
   - Verify email received

2. **Edge Cases**:
   - Student without email address
   - Teacher without signature (verify fallback)
   - Invalid class ID
   - Invalid student ID
   - Network errors during send

3. **UI/UX**:
   - Button visibility for admin vs teacher vs student
   - Confirmation dialog clarity
   - Loading state during generation
   - Success/error messages
   - Email link accessibility

## Files Modified

1. `/routes/admin.js`
   - Added PDFDocument import
   - Added dataUrlToBuffer() helper
   - Added buildCompletionPdf() helper
   - Added POST /admin/classes/:classId/students/:studentId/send-completion-certificate route

2. `/views/student_profile.ejs`
   - Added "Send Certificate" button in grades section (line ~1125)
   - Added sendCompletionCertificate() JavaScript function (line ~2860)

## Related Documentation

- See `SIGNATURE_FALLBACK_FEATURE.md` for signature handling details
- See `GRADE_MANAGEMENT_FEATURE.md` for grade system context
- See certificate generation in `/routes/student.js` for view-only certificates
