# SMTP Email Configuration Guide

## Current Status
✅ **System is working** - Document signing functionality operates even without email configuration  
⚠️ **Emails disabled** - Email notifications won't be sent until SMTP is properly configured

---

## Email Functionality

When configured, the system sends emails for:
- 📧 **Signature requests** - When a document is sent for signature
- ✅ **Completion notifications** - When all parties have signed
- 🔔 **Reminder emails** - For pending signatures (optional)

When NOT configured:
- ✨ System functions normally
- 📋 Documents can still be created and signed
- 🔗 Sign URLs are printed to console logs
- 👥 Users can manually navigate to their pending documents

---

## SMTP Configuration Options

### Option 1: Gmail (Easiest for Testing)

```env
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USER=your-email@gmail.com
SMTP_PASS=your-app-password
SMTP_FROM=your-email@gmail.com
```

**Important**: You must use an **App Password**, not your regular Gmail password
1. Go to Google Account Settings
2. Security → 2-Step Verification (enable if not already)
3. Search for "App Passwords"
4. Create an app password for "Mail"
5. Use that 16-character password in SMTP_PASS

### Option 2: Custom Domain (mdts-apps.com)

For your current email `noreply@mdts-apps.com`, you need:

```env
SMTP_HOST=mail.mdts-apps.com  # or smtp.mdts-apps.com
SMTP_PORT=587                 # or 465 for SSL, 25 for non-secure
SMTP_USER=noreply@mdts-apps.com
SMTP_PASS=your-email-password
SMTP_FROM=noreply@mdts-apps.com
```

**Where to find these settings:**
- Contact your domain/email provider (GoDaddy, Namecheap, etc.)
- Check cPanel → Email Accounts → Configure Mail Client
- Look for "Outgoing Mail Server" or "SMTP Settings"

Common SMTP hosts by provider:
- **GoDaddy**: `smtpout.secureserver.net`, port 465 (SSL) or 587
- **Namecheap**: `mail.privateemail.com`, port 587
- **cPanel**: Usually `mail.yourdomain.com`, port 587
- **Office 365**: `smtp.office365.com`, port 587

### Option 3: Third-Party Email Service (Recommended for Production)

**SendGrid** (Free tier: 100 emails/day)
```env
SMTP_HOST=smtp.sendgrid.net
SMTP_PORT=587
SMTP_USER=apikey
SMTP_PASS=your-sendgrid-api-key
SMTP_FROM=noreply@mdts-apps.com
```

**Mailgun** (Free tier: 5,000 emails/month)
```env
SMTP_HOST=smtp.mailgun.org
SMTP_PORT=587
SMTP_USER=postmaster@your-domain.mailgun.org
SMTP_PASS=your-mailgun-smtp-password
SMTP_FROM=noreply@mdts-apps.com
```

**Amazon SES** (62,000 emails/month free with AWS Free Tier)
```env
SMTP_HOST=email-smtp.us-east-1.amazonaws.com
SMTP_PORT=587
SMTP_USER=your-ses-smtp-username
SMTP_PASS=your-ses-smtp-password
SMTP_FROM=noreply@mdts-apps.com
```

---

## Testing SMTP Configuration

### 1. Update `.env` file
Add your SMTP settings to `/Users/backupadmin/Documents/GitHub/NewLMS/Archive 2/.env`

### 2. Restart the server
```bash
npm start
```

### 3. Test by sending a document for signature
1. Go to Document Signing → Create Document
2. Upload a PDF and add fields
3. Click "Send for Signature"
4. Check the console logs:

**Success:**
```
Email sent successfully to: user@example.com
```

**Failure (with helpful info):**
```
Error sending email: [error details]
Sign URL for user@example.com: http://localhost:3012/document-signing/sign/...
```

### 4. Common Errors and Solutions

**"Missing credentials for PLAIN"**
- SMTP_USER or SMTP_PASS is not set or incorrect
- Solution: Double-check your .env file

**"Invalid login"**
- Incorrect username/password
- For Gmail: Use App Password, not regular password
- Solution: Verify credentials with your email provider

**"Connection timeout"**
- Wrong SMTP_HOST or SMTP_PORT
- Firewall blocking outgoing SMTP
- Solution: Verify host/port settings, check firewall

**"Self-signed certificate"**
- SSL certificate issue
- Solution: Try port 587 instead of 465, or add `secure: false`

---

## Current Configuration

Your current `.env` file has:
```env
SMTP_HOST=mail.mdts-apps.com
SMTP_PORT=587
SMTP_USER=noreply@mdts-apps.com
SMTP_PASS=c@r,5ysPI@&s
```

**To enable emails:**
1. Verify these settings with your email provider
2. Test with a simple email client or ask your provider
3. Common issues:
   - Wrong hostname (try `smtp.mdts-apps.com` instead)
   - Port may need to be 465 (SSL) or 25
   - Password may need to be updated

**To disable emails temporarily:**
1. Comment out SMTP settings in .env:
```env
# SMTP_HOST=mail.mdts-apps.com
# SMTP_PORT=587
```
2. System will print sign URLs to console instead

---

## Production Recommendations

### Security
- ✅ Never commit `.env` file to Git
- ✅ Use environment variables on production server
- ✅ Use App Passwords or API keys (not personal passwords)
- ✅ Enable 2FA on email accounts

### Reliability
- 📧 Use dedicated email service (SendGrid, Mailgun, SES)
- 🔄 Implement retry logic for failed emails
- 📊 Monitor email delivery rates
- 🗃️ Log all email attempts for debugging

### Deliverability
- ✉️ Use proper "from" address (no-reply@yourdomain.com)
- ✅ Set up SPF, DKIM, DMARC records for your domain
- 📝 Include text version of emails (not just HTML)
- 🚫 Avoid spam trigger words in subject/body

---

## Quick Fix for Right Now

**Option A: Disable emails temporarily**
The system will work perfectly without emails. Sign URLs will be printed to console:
```env
# SMTP_HOST=mail.mdts-apps.com
# SMTP_PORT=587  
# SMTP_USER=noreply@mdts-apps.com
# SMTP_PASS=c@r,5ysPI@&s
```

**Option B: Use Gmail for testing**
1. Create/use a Gmail account
2. Generate an App Password
3. Update .env:
```env
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USER=youremail@gmail.com
SMTP_PASS=your-16-char-app-password
SMTP_FROM=youremail@gmail.com
```

**Option C: Contact your email provider**
Get the correct SMTP settings for `noreply@mdts-apps.com` from your domain hosting provider.

---

## Support

If you need help:
1. Check server console logs for sign URLs
2. Test SMTP settings with a mail client (Thunderbird, Mail.app)
3. Contact your email/domain provider for correct SMTP settings
4. Consider using a third-party service for easier setup

The document signing system is fully functional with or without email - emails are just a convenience feature!
