const db = require('../models/db');

async function addLinksColumn() {
  try {
    // Check if links column exists
    const [columns] = await db.query("SHOW COLUMNS FROM mdtslms_classes LIKE 'links'");
    
    if (columns.length === 0) {
      console.log('Adding links column to mdtslms_classes table...');
      await db.query('ALTER TABLE mdtslms_classes ADD COLUMN links JSON DEFAULT NULL');
      console.log('✓ Links column added successfully');
    } else {
      console.log('✓ Links column already exists');
    }
    
    process.exit(0);
  } catch (error) {
    console.error('Error:', error);
    process.exit(1);
  }
}

addLinksColumn();
