const pool = require('../models/db');

async function setupTestProgress() {
  try {
    console.log('Setting up test_progress table...');
    
    // Create test_progress table
    await pool.query(`
      CREATE TABLE IF NOT EXISTS test_progress (
        id INT AUTO_INCREMENT PRIMARY KEY,
        student_id INT NOT NULL,
        class_id INT NOT NULL,
        test_id INT NOT NULL,
        answers JSON,
        time_remaining INT,
        started_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        last_saved_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        completed BOOLEAN DEFAULT FALSE,
        INDEX idx_student_test (student_id, class_id, test_id),
        UNIQUE KEY unique_in_progress (student_id, class_id, test_id, completed)
      )
    `);
    
    console.log('✅ test_progress table created successfully');
    process.exit(0);
  } catch (error) {
    console.error('❌ Error setting up test_progress table:', error);
    process.exit(1);
  }
}

setupTestProgress();
