const fs = require('fs');
const path = require('path');

const LIB_PATH = path.join(__dirname, '..', 'data', 'resourceLibrary.json');

function loadLibrary() {
  try {
    return JSON.parse(fs.readFileSync(LIB_PATH, 'utf8'));
  } catch (e) {
    return { lectures: [], assignments: [], tests: [] };
  }
}

function saveLibrary(lib) {
  fs.writeFileSync(LIB_PATH, JSON.stringify(lib, null, 2));
}

function add(type, entry, keyField) {
  const lib = loadLibrary();
  lib[type] = lib[type] || [];
  if (!lib[type].some(i => i[keyField] === entry[keyField])) {
    lib[type].push(entry);
    saveLibrary(lib);
  }
}

function addLecture(lecture) {
  add('lectures', lecture, 'url');
}

function addAssignment(assignment) {
  add('assignments', assignment, 'url');
}

function addTest(test) {
  add('tests', test, 'title');
}

function updateTest(oldTitle, updates) {
  const lib = loadLibrary();
  lib.tests = lib.tests || [];
  const idx = lib.tests.findIndex(t => t.title === oldTitle);
  if (idx >= 0) {
    lib.tests[idx] = { ...lib.tests[idx], ...updates };
    saveLibrary(lib);
  }
}

function removeTest(title) {
  const lib = loadLibrary();
  lib.tests = (lib.tests || []).filter(t => t.title !== title);
  saveLibrary(lib);
}

module.exports = {
  loadLibrary,
  addLecture,
  addAssignment,
  addTest,
  updateTest,
  removeTest
};
